<?php
if (isset($_POST['generate'])) {

  if (!is_dir('uploads')) mkdir('uploads', 0777, true);

  $colorMap = $_POST['color_map'];
  $outputImg = "uploads/wordcloud_" . time() . ".png";
  $pythonPath = "C:\\laragon\\bin\\python\\python-3.10\\python.exe";

  // Tentukan sumber teks: dari textarea atau file
  if (!empty($_POST['textinput'])) {
    // Simpan teks dari textarea ke file sementara
    $tempText = "uploads/temp_text_" . time() . ".txt";
    file_put_contents($tempText, $_POST['textinput']);
    $textFile = $tempText;
  } elseif (!empty($_FILES['textfile']['tmp_name'])) {
    $textFile = $_FILES['textfile']['tmp_name'];
  } else {
    $textFile = "";
  }

  if ($textFile !== "") {
    // Jalankan script Python TANPA mask_shape
    $command = "\"$pythonPath\" generate_wordcloud.py \"$textFile\" \"$outputImg\" \"$colorMap\"";
    exec($command . " 2>&1", $output, $return_var);

    // echo "<pre>";
    // print_r($output);
    // echo "</pre>";

    $img = $outputImg;
  }
}
?>
<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <title>Word Cloud Generator | Dashboard</title>
  <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="assets/plugins/overlayScrollbars/css/OverlayScrollbars.min.css">
  <link rel="stylesheet" href="assets/dist/css/adminlte.min.css">
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
      <ul class="navbar-nav">
        <li class="nav-item">
          <a class="nav-link" data-widget="pushmenu" href="#"><i class="fas fa-bars"></i></a>
        </li>
        <li class="nav-item d-none d-sm-inline-block">
          <a href="index.php" class="nav-link">Home</a>
        </li>
      </ul>
    </nav>

    <aside class="main-sidebar sidebar-dark-primary elevation-4">
      <a href="index.php" class="brand-link">
        <i class="fas fa-cloud ml-2"></i>
        <span class="brand-text font-weight-light ml-2">Word Cloud App</span>
      </a>
      <div class="sidebar">
        <nav class="mt-2">
          <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview">
            <li class="nav-item">
              <a href="index.php" class="nav-link active">
                <i class="nav-icon fas fa-chart-area"></i>
                <p>Generator</p>
              </a>
            </li>
          </ul>
        </nav>
      </div>
    </aside>

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <h1 class="m-0 text-dark">Word Cloud Generator</h1>
        </div>
      </div>

      <section class="content">
        <div class="container-fluid">

          <div class="card card-primary card-outline">
            <div class="card-header">
              <h3 class="card-title"><i class="fas fa-edit"></i> Buat Word Cloud</h3>
            </div>
            <form method="POST" enctype="multipart/form-data" action="index.php">
              <div class="card-body">

                <div class="form-group">
                  <label>Tulis Teks Secara Manual:</label>
                  <textarea name="textinput" class="form-control" rows="5" placeholder="Tulis teks di sini..."></textarea>
                </div>

                <div class="form-group">
                  <label>Atau Upload File Teks (.txt):</label>
                  <input type="file" name="textfile" class="form-control">
                  <small class="form-text text-muted">Jika kamu isi dua-duanya, sistem akan memakai teks yang diketik.</small>
                </div>

                <div class="form-group mt-3">
                  <label>Pilih Tema Warna:</label>
                  <select name="color_map" class="form-control">
                    <option value="viridis">Hijau - Biru (default)</option>
                    <option value="plasma">Ungu - Kuning</option>
                    <option value="inferno">Merah - Hitam</option>
                    <option value="cool">Biru - Pink</option>
                    <option value="spring">Pink Cerah</option>
                  </select>
                </div>

                <button type="submit" name="generate" class="btn btn-success btn-block">
                  <i class="fas fa-magic"></i> Generate Word Cloud
                </button>
              </div>
            </form>
          </div>

          <div class="card card-success card-outline">
            <div class="card-header">
              <h3 class="card-title"><i class="fas fa-image"></i> Hasil Word Cloud</h3>
            </div>
            <div class="card-body text-center">
              <?php if (!empty($img) && file_exists($img)): ?>
                <img src="<?php echo htmlspecialchars($img); ?>" alt="WordCloud" class="img-fluid shadow rounded">
                <a href="<?php echo htmlspecialchars($img); ?>" download class="btn btn-info mt-3">
                  <i class="fas fa-download"></i> Download Word Cloud
                </a>
              <?php else: ?>
                <p class="text-muted">Belum ada hasil. Ketik teks atau unggah file lalu klik "Generate".</p>
              <?php endif; ?>
            </div>
          </div>

          <div class="card card-warning card-outline">
            <div class="card-header">
              <h3 class="card-title"><i class="fas fa-list"></i> 10 Kata Paling Sering Muncul</h3>
            </div>
            <div class="card-body">
              <?php
              if (file_exists("uploads/stats.txt")) {
                echo "<ul>";
                foreach (file("uploads/stats.txt") as $line) {
                  list($word, $freq) = explode(",", trim($line));
                  echo "<li><b>" . htmlspecialchars($word) . "</b>: " . htmlspecialchars($freq) . " kali</li>";
                }
                echo "</ul>";
              } else {
                echo "<p class='text-muted'>Belum ada data statistik.</p>";
              }
              ?>
            </div>
          </div>

        </div>
      </section>
    </div>
  </div>

  <script src="assets/plugins/jquery/jquery.min.js"></script>
  <script src="assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
  <script src="assets/dist/js/adminlte.min.js"></script>
</body>

</html>