import os
import sys
from pathlib import Path

# FIX agar matplotlib tidak error di lingkungan PHP/Laragon
try:
    home_dir = str(Path(__file__).parent.resolve())  # ambil folder project
    os.environ["HOME"] = home_dir
    os.environ["MPLCONFIGDIR"] = os.path.join(home_dir, "matplotlib_config")
    if not os.path.exists(os.environ["MPLCONFIGDIR"]):
        os.makedirs(os.environ["MPLCONFIGDIR"])
except Exception as e:
    print(f"Warning: HOME fix failed - {e}")

from wordcloud import WordCloud
import matplotlib.pyplot as plt
from collections import Counter
from PIL import Image
import numpy as np


# ✅ FIX untuk error "Could not determine home directory"
if not os.environ.get("HOME"):
    os.environ["HOME"] = os.getcwd()

# ✅ Ambil argumen dari PHP
input_path = sys.argv[1]
output_path = sys.argv[2]
color_map = sys.argv[3] if len(sys.argv) > 3 else "viridis"
mask_shape = sys.argv[4] if len(sys.argv) > 4 else ""

# ✅ Baca teks dari file input
try:
    with open(input_path, "r", encoding="utf-8") as f:
        text = f.read().strip()
except FileNotFoundError:
    print("ERROR: File input tidak ditemukan:", input_path)
    sys.exit(1)

# ✅ Pastikan teks tidak kosong
if not text:
    print("ERROR: File teks kosong atau tidak berisi kata apapun.")
    sys.exit(1)

# ✅ Siapkan mask (bentuk)
mask = None
if mask_shape:
    mask_path = os.path.join("masks", f"{mask_shape}.png")
    if os.path.exists(mask_path):
        mask = np.array(Image.open(mask_path))
    else:
        print(f"WARNING: Mask {mask_path} tidak ditemukan, pakai bentuk default.")

# ✅ Buat Word Cloud
try:
    wc = WordCloud(
        width=800,
        height=400,
        background_color="white",
        colormap=color_map,
        max_words=150,
        mask=mask
    ).generate(text)

    # Simpan gambar ke output
    wc.to_file(output_path)
    print(f"SUKSES: Word cloud disimpan di {output_path}")

except Exception as e:
    print("ERROR saat membuat word cloud:", str(e))
    sys.exit(1)

# ✅ Buat statistik kata
words = text.split()
counts = Counter(words)
most_common = counts.most_common(10)

# ✅ Pastikan folder uploads ada
if not os.path.exists("uploads"):
    os.makedirs("uploads")

# Simpan statistik ke file
stats_path = os.path.join("uploads", "stats.txt")
with open(stats_path, "w", encoding="utf-8") as f:
    for word, freq in most_common:
        f.write(f"{word},{freq}\n")

print("SUKSES: Statistik kata disimpan di uploads/stats.txt")
