<section class="content-header mb-4">
    <h4 class="fw-bold">Dashboard</h4>
    <small class="text-muted">Ringkasan Sistem POS</small>
</section>

<div class="row g-4">

    
    <div class="col-md-3">
        <div class="card shadow-sm">
            <div class="card-body d-flex align-items-center">
                <div class="me-3">
                    <div class="avatar avatar-lg bg-primary" style="
                        width: 35px;
                        height: 35px;
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    ">
                        <i class="dripicons dripicons-cart text-white"></i>
                    </div>
                </div>
                <div>
                    <h6 class="text-muted mb-0">Total Transaksi</h6>
                    <h4 class="fw-bold mb-0"><?php echo e($totalTransaksi); ?></h4>
                </div>
            </div>
        </div>
    </div>

    
    <div class="col-md-3">
        <div class="card shadow-sm">
            <div class="card-body d-flex align-items-center">
                <div class="me-3">
                    <div class="avatar avatar-lg bg-success"
                        style="
                        width: 35px;
                        height: 35px;
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    ">
                        <i class="dripicons dripicons-user text-white"></i>
                    </div>
                </div>
                <div>
                    <h6 class="text-muted mb-0">Total Pelanggan</h6>
                    <h4 class="fw-bold mb-0"><?php echo e($totalPelanggan); ?></h4>
                </div>
            </div>
        </div>
    </div>

    
    <div class="col-md-3">
        <div class="card shadow-sm">
            <div class="card-body d-flex align-items-center">
                <div class="me-3">
                    <div class="avatar avatar-lg bg-danger"
                        style="
                        width: 35px;
                        height: 35px;
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    ">
                        <i class="dripicons dripicons-tags text-white"></i>
                    </div>
                </div>
                <div>
                    <h6 class="text-muted mb-0">Total Kategori</h6>
                    <h4 class="fw-bold mb-0"><?php echo e($totalKategori); ?></h4>
                </div>
            </div>
        </div>
    </div>

    
    <div class="col-md-3">
        <div class="card shadow-sm">
            <div class="card-body d-flex align-items-center">
                <div class="me-3">
                    <div class="avatar avatar-lg bg-info" style="
                        width: 35px;
                        height: 35px;
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    ">

                        <i class="dripicons dripicons-card text-white"></i>
                    </div>
                </div>
                <div>
                    <h6 class="text-muted mb-0">Total Metode</h6>
                    <h4 class="fw-bold mb-0"><?php echo e($totalMetode); ?></h4>
                </div>
            </div>
        </div>
    </div>


    
    <div class="col-md-6">
        <div class="card shadow-sm">
            <div class="card-header">
                <h6 class="mb-0 fw-bold">
                    <i class="dripicons dripicons-card me-1"></i>
                    Transaksi per Metode
                </h6>
            </div>
            <div class="card-body">
                <?php if($transaksiMetode->count() > 0): ?>
                <ul class="list-group list-group-flush">
                    <?php $__currentLoopData = $transaksiMetode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-group-item d-flex justify-content-between">
                        <span><?php echo e($m->nama_metode); ?></span>
                        <span class="badge bg-primary">
                            <?php echo e($m->total); ?>

                        </span>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <?php else: ?>
                <small class="text-muted">Belum ada data</small>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card shadow-sm">
            <div class="card-header">
                <h6 class="mb-0 fw-bold">
                    <i class="dripicons dripicons-box me-1"></i>
                    Top 5 Produk Terjual
                </h6>
            </div>
            <div class="card-body">
                <?php if($topProduk->count() > 0): ?>
                <ul class="list-group list-group-flush">
                    <?php $__currentLoopData = $topProduk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-group-item d-flex justify-content-between">
                        <span><?php echo e($item->produk); ?></span>
                        <span class="badge bg-success">
                            <?php echo e($item->total_terjual); ?>

                        </span>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <?php else: ?>
                <small class="text-muted">Belum ada data</small>
                <?php endif; ?>
            </div>
        </div>
    </div>



</div><?php /**PATH D:\WebsitePos\resources\views/pages/dashboard.blade.php ENDPATH**/ ?>