<div class="card">
    <div class="card-header">
        <h5>Data Produk Terlaris</h5>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table id="table-produk" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Produk</th>
                        <th>Kategori</th>
                        <th>Harga</th>
                        <th>Total Terjual</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function () {
    $('#table-produk').DataTable({
        processing: true,
        ajax: {
            url: '/produk/data',
            dataSrc: ''
        },
        pageLength: 10,
        lengthChange: false,
        ordering: true,
        searching: true,
        columns: [
            {
                data: null,
                render: function (data, type, row, meta) {
                    return meta.row + 1;
                }
            },
            { data: 'produk' },
            { data: 'nama_kategori' },
            {
                data: 'harga_satuan',
                render: function (data) {
                    return 'Rp ' + parseInt(data).toLocaleString('id-ID');
                }
            },
            {
                data: 'total_terjual',
                render: function (data) {
                    return '<span class="badge bg-primary">' + data + '</span>';
                }
            }
        ]
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\WebsitePos\resources\views/pages/produk.blade.php ENDPATH**/ ?>