<!DOCTYPE html>
<html lang="id" data-bs-theme="dark">
<head>
    <meta charset="UTF-8">
    <title>Login Admin</title>

    <link rel="stylesheet" href="<?php echo e(asset('mazer/assets/compiled/css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('mazer/assets/compiled/css/app-dark.css')); ?>">
</head>

<body>
<div class="container d-flex justify-content-center align-items-center" style="height:100vh">

    <div class="card col-md-4">
        <div class="card-body">

            <h4 class="text-center mb-4">Login Admin</h4>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <form method="POST" action="/login">
                <?php echo csrf_field(); ?>

                <div class="mb-3">
                    <label>Username</label>
                    <input type="text" name="username" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label>Password</label>
                    <input type="password" name="password" class="form-control" required>
                </div>

                <button class="btn btn-primary w-100">
                    Login
                </button>
            </form>

        </div>
    </div>

</div>
</body>
</html>
<?php /**PATH D:\WebsitePos\resources\views/auth/login.blade.php ENDPATH**/ ?>