<?php

use Illuminate\Support\Facades\Route; // ✅ WAJIB
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\TransaksiController;
use App\Http\Controllers\ProdukController;
use App\Http\Controllers\PelangganController;
use App\Http\Controllers\AuthController;



Route::get('/', function () {
    return redirect('/login');
});

/*
|--------------------------------------------------------------------------
| AUTH (TANPA MIDDLEWARE)
|--------------------------------------------------------------------------
*/
Route::get('/login', [AuthController::class, 'login'])->name('login');
Route::post('/login', [AuthController::class, 'prosesLogin']);

/*
|--------------------------------------------------------------------------
| SEMUA FITUR (WAJIB LOGIN)
|--------------------------------------------------------------------------
*/
Route::middleware('auth.session')->group(function () {

    Route::get('/dashboard', [DashboardController::class, 'index']);


    // TRANSAKSI
    Route::get('/transaksi', [TransaksiController::class, 'index']);
    Route::get('/transaksi/data', [TransaksiController::class, 'data']);
    Route::get('/transaksi/export', [TransaksiController::class, 'export']);

    // PRODUK
    Route::get('/produk', [ProdukController::class, 'index']);
    Route::get('/produk/data', function () {
        $tm = new \App\Models\TransaksiModel();
        return response()->json($tm->getRekapProduk());
    });

    // PELANGGAN
    Route::get('/pelanggan', [PelangganController::class, 'index']);
    Route::get('/pelanggan/data', [PelangganController::class, 'data']);
    Route::post('/pelanggan/store', [PelangganController::class, 'store']);
    Route::get('/pelanggan/edit/{id}', [PelangganController::class, 'edit']);
    Route::post('/pelanggan/update/{id}', [PelangganController::class, 'update']);
    Route::post('/pelanggan/delete/{id}', [PelangganController::class, 'delete']);

    // LOGOUT
    Route::get('/logout', [AuthController::class, 'logout']);
});
