<div class="card">

    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Data Transaksi</h5>

        <a href="/transaksi/export" class="btn btn-success btn-sm">
            <i class="bi bi-file-earmark-excel"></i> Export Excel
        </a>
    </div>


    <div class="card-body">
        <div class="table-responsive">
            <table id="table-transaksi" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Tanggal</th>
                        <th>Nama Pelanggan</th>
                        <th>Status</th>
                        <th>Metode Pembayaran</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        $('#table-transaksi').DataTable({
            ajax: {
                url: '/transaksi/data',
                dataSrc: ''
            },
            pageLength: 10,
            lengthChange: false,
            ordering: true,
            searching: true,
            columns: [{
                    data: null,
                    render: function(data, type, row, meta) {
                        return meta.row + 1;
                    }
                },
                {
                    data: 'tanggal',
                    render: function(data) {
                        let t = new Date(data);
                        return t.toLocaleDateString('id-ID');
                    }
                },
                {
                    data: 'nama_pelanggan'

                },
                {
                    data: 'status',
                    render: function(data) {
                        return data === 'Lunas' ?
                            '<span class="badge bg-success">Lunas</span>' :
                            '<span class="badge bg-warning">Pending</span>';
                    }
                },
                {
                    data: 'nama_metode'

                }
            ]
        });
    });
</script>
@endpush