<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Data Pelanggan</h5>

        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalTambahPelanggan">
            <i class="bi bi-plus-lg"></i> Tambah Pelanggan
        </button>

    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table id="table-pelanggan" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Pelanggan</th>
                        <th>Alamat</th>
                        <th>No. Telp</th>
                        <th>Jenis Kelamin</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<div class="modal fade" id="modalTambahPelanggan" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" action="/pelanggan/store" class="modal-content">
            @csrf

            <div class="modal-header">
                <h5 class="modal-title">Tambah Pelanggan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <div class="mb-3">
                    <label>Nama Pelanggan</label>
                    <input type="text" name="nama_pelanggan" class="form-control">
                </div>

                <div class="mb-3">
                    <label>Alamat</label>
                    <textarea name="alamat" class="form-control"></textarea>
                </div>

                <div class="mb-3">
                    <label>No Telp</label>
                    <input type="text" name="no_telp" class="form-control">
                </div>

                <div class="mb-3">
                    <label>Jenis Kelamin</label>
                    <select name="jenis_kelamin" class="form-select">
                        <option value="L">Laki-laki</option>
                        <option value="P">Perempuan</option>
                    </select>
                </div>
            </div>

            <div class="modal-footer">
                <button class="btn btn-primary">Simpan</button>
            </div>

        </form>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        $('#table-pelanggan').DataTable({
            ajax: {
                url: '/pelanggan/data',
                dataSrc: ''
            },
            pageLength: 10,
            lengthChange: false,
            ordering: true,
            searching: true,
            columns: [{
                    data: null,
                    render: function(data, type, row, meta) {
                        return meta.row + 1;
                    }
                },
                {
                    data: 'nama_pelanggan'
                },
                {
                    data: 'alamat'
                },
                {
                    data: 'no_telp'
                },
                {
                    data: 'jenis_kelamin'
                },
                {
                    data: 'id_pelanggan',
                    orderable: false,
                    searchable: false,
                    render: function(id) {
                        return `
                            <a href="/pelanggan/edit/${id}" class="btn btn-success btn-sm">
                                Update
                            </a>
                            <button class="btn btn-danger btn-sm" onclick="hapusPelanggan(${id})">
                                Hapus
                            </button>
                        `;
                    }
                }
            ]
        });
    });

    function hapusPelanggan(id) {
        if (!confirm('Yakin ingin menghapus pelanggan ini?')) return;

        $.ajax({
            url: '/pelanggan/delete/' + id,
            type: 'POST',
            data: {
                _token: '{{ csrf_token() }}'
            },
            success: function() {
                $('#table-pelanggan').DataTable().ajax.reload();
                alert('Data berhasil dihapus');
            },
            error: function() {
                alert('Gagal menghapus data');
            }
        });
    }
</script>
@endpush