<!DOCTYPE html>
<html lang="id" data-bs-theme="dark">

<head>
    <meta charset="utf-8">
    <title>POS Dashboard | Laravel 12</title>

    {{-- CORE CSS --}}
    <link rel="stylesheet" href="{{ asset('mazer/assets/compiled/css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('mazer/assets/compiled/css/app-dark.css') }}">

    {{-- ICON & PLUGIN --}}
    <link rel="stylesheet" href="{{ asset('mazer/assets/extensions/bootstrap-icons/font/bootstrap-icons.css') }}">
    <link rel="stylesheet" href="{{ asset('mazer/assets/extensions/@icon/dripicons/dripicons.css') }}">
    <link rel="stylesheet" href="{{ asset('mazer/assets/extensions/perfect-scrollbar/perfect-scrollbar.css') }}">
    <link rel="stylesheet" href="{{ asset('mazer/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css') }}">

    <script src="{{ asset('mazer/assets/static/js/initTheme.js') }}"></script>
</head>


<body>
    <div id="app">
        {{-- SIDEBAR --}}
        <div id="sidebar" class="active">
            <div class="sidebar-wrapper active">

                <div class="sidebar-header text-center py-4">
                    <div class="logo d-flex align-items-center justify-content-center gap-2">
                        <i class="dripicons-cart fs-3 text-primary"></i>
                        <div class="text-start">
                            <h5 class="mb-0 fw-bold text-white">POS System</h5>
                            <small class="text-muted">Laravel 12</small>

                        </div>
                    </div>
                </div>
                <hr class="sidebar-divider my-2 opacity-25">



                <div class="sidebar-menu">
                    <ul class="menu">
                        <li class="sidebar-title">Menu Utama</li>

                        <li class="sidebar-item {{ $page === 'dashboard' ? 'active' : '' }}">
                            <a href="{{ url('/') }}" class="sidebar-link">
                                <i class="bi bi-speedometer2"></i>
                                <span>Dashboard</span>
                            </a>
                        </li>

                        <li class="sidebar-item {{ $page === 'transaksi' ? 'active' : '' }}">
                            <a href="{{ url('/transaksi') }}" class="sidebar-link">
                                <i class="bi bi-credit-card"></i>
                                <span>Transaksi</span>
                            </a>
                        </li>

                        <li class="sidebar-item {{ $page === 'produk' ? 'active' : '' }}">
                            <a href="{{ url('/produk') }}" class="sidebar-link">
                                <i class="bi bi-box-seam"></i>
                                <span>Produk</span>
                            </a>
                        </li>


                        <li class="sidebar-item {{ $page === 'pelanggan' ? 'active' : '' }}">
                            <a href="{{ url('/pelanggan') }}" class="sidebar-link">
                                <i class="bi bi-people"></i>
                                <span>Pelanggan</span>
                            </a>
                        </li>

                        <hr class="sidebar-divider my-2">

                        <li class="sidebar-item">
                            <a href="{{ url('/logout') }}" class="sidebar-link">
                                <i class="bi bi-box-arrow-right"></i>
                                <span>Logout</span>
                            </a>
                        </li>

                    </ul>
                </div>
            </div>
        </div>

        {{-- MAIN --}}
        <div id="main" class="layout-navbar">

            {{-- NAVBAR --}}
            <header class="mb-3">
                <nav class="navbar navbar-expand navbar-dark navbar-top">
                    <div class="container-fluid">

                        <a href="#" class="burger-btn d-block">
                            <i class="bi bi-justify fs-3"></i>
                        </a>

                        <span class="ms-3 fw-semibold text-white">
                            Point of Sale Dashboard
                        </span>


                        <div class="ms-auto">
                            <span class="text-muted small">POS Application</span>
                        </div>
                    </div>
                </nav>
            </header>

            {{-- CONTENT --}}
            <div id="main-content">
                <div class="page-content">
                    @include('pages.' . $page)
                </div>
            </div>

            {{-- FOOTER --}}
            <footer>
                <div class="footer clearfix mb-0 text-muted">
                    <div class="float-start">
                        <p>2025 &copy; POS System</p>
                    </div>
                    <div class="float-end">
                        <p>Laravel <b>Web Programming</b></p>
                    </div>
                </div>
            </footer>

        </div>
    </div>

    {{-- ================= JS (URUTAN WAJIB) ================= --}}
    <script src="{{ asset('mazer/assets/extensions/jquery/jquery.min.js') }}"></script>
    <script src="{{ asset('mazer/assets/extensions/perfect-scrollbar/perfect-scrollbar.min.js') }}"></script>

    <script src="{{ asset('mazer/assets/extensions/datatables.net/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('mazer/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js') }}"></script>

    <script src="{{ asset('mazer/assets/compiled/js/app.js') }}"></script>

    @stack('scripts')
</body>

</html>