<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;

class TransaksiModel
{
    // total transaksi (jumlah header)
    public function getTotalTransaksi()
    {
        return DB::table('transaksi')->count();
    }

    // total kategori
    public function getTotalKategori()
    {
        return DB::table('kategori')->count();
    }

    public function getTransaksiPerMetode()
    {
        return DB::table('metode as m')
            ->leftJoin('transaksi as t', 't.id_metode', '=', 'm.id_metode')
            ->select(
                'm.nama_metode',
                DB::raw('COUNT(t.id_transaksi) as total')
            )
            ->groupBy('m.id_metode', 'm.nama_metode')
            ->get();
    }

    public function getRekapProduk()
    {
        return DB::table('detail_transaksi as d')
        ->join('kategori as k', 'k.id_kategori', '=', 'd.id_kategori')
        ->select(
            'd.produk',
            'k.nama_kategori',
            'd.harga_satuan',
            DB::raw('SUM(d.jumlah) as total_terjual')
        )
        ->groupBy('d.produk', 'k.nama_kategori', 'd.harga_satuan')
        ->orderByDesc('total_terjual')
        ->get();
    }

   public function getAllTransaksi()
    {
        return DB::table('transaksi as t')
            ->join('pelanggan as p', 'p.id_pelanggan', '=', 't.id_pelanggan')
            ->join('metode as m', 'm.id_metode', '=', 't.id_metode')
            ->join('detail_transaksi as d', 'd.id_transaksi', '=', 't.id_transaksi')
            ->select(
                't.id_transaksi',
                't.tanggal',
                'p.nama_pelanggan',
                'm.nama_metode',
                DB::raw('SUM(d.jumlah * d.harga_satuan) as total')
            )
            ->groupBy(
                't.id_transaksi',
                't.tanggal',
                'p.nama_pelanggan',
                'm.nama_metode'
            )
            ->orderByDesc('t.tanggal')
            ->get();
    }
}
