<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use App\Exports\TransaksiExport;
use Maatwebsite\Excel\Facades\Excel;

class TransaksiController extends Controller
{
    public function index()
    {
        return view('layout.main', [
            'page' => 'transaksi'
        ]);
    }

    // DATA UNTUK DATATABLE (CLIENT SIDE)
    public function data()
    {
        $data = DB::table('transaksi as t')
            ->join('pelanggan as p', 'p.id_pelanggan', '=', 't.id_pelanggan')
            ->join('metode as m', 'm.id_metode', '=', 't.id_metode')
            ->select(
                't.id_transaksi',
                't.tanggal',
                'p.nama_pelanggan',
                't.status',
                'm.nama_metode'
            )
            ->orderBy('t.tanggal', 'desc')
            ->get();

        return response()->json($data);
    }

    
    public function export()
    {
        return Excel::download(
            new TransaksiExport,
            'data-transaksi.xlsx'
        );
    }
}
