<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use App\Models\TransaksiModel;
use App\Models\PelangganModel;

class DashboardController extends Controller
{
    public function index()
    {
        // 🔐 proteksi login manual
        if (!session('login')) {
            return redirect('/login');
        }

        $tm = new TransaksiModel();
        $pm = new PelangganModel();

        // 🔝 TOP 5 PRODUK TERJUAL
        $topProduk = DB::table('detail_transaksi')
            ->select(
                'produk',
                DB::raw('SUM(jumlah) as total_terjual')
            )
            ->groupBy('produk')
            ->orderByDesc('total_terjual')
            ->limit(5)
            ->get();

        return view('layout.main', [
            'page'              => 'dashboard',
            'totalTransaksi'    => $tm->getTotalTransaksi(),
            'totalPelanggan'    => $pm->getTotal(),
            'totalKategori'     => $tm->getTotalKategori(),
            'totalMetode'       => DB::table('metode')->count(),
            'transaksiMetode'   => $tm->getTransaksiPerMetode(),
            'topProduk'         => $topProduk,
        ]);
    }
}
